openMap();

function toggleSidePanel(){
  if(devices.className === "devices"){
    devices.classList.replace("devices", "devices-minimized");
    togglePanelIcon.classList.replace("togglePanelIcon", "togglePanelIconClosed");
  }
  else{
    devices.classList.replace("devices-minimized", "devices");
    togglePanelIcon.classList.replace("togglePanelIconClosed", "togglePanelIcon");
  }
}

hd_canvas.parentElement.style.display = "";
thermal_canvas.parentElement.style.display = "";

// Return from fullscreen mode with esc key
function handleEscapeKeyPress(e) {
    if(e.key === "Escape") {
      if(hd_canvas.className.includes("fullscreen")){
        toggleFullScreen("hd_canvas");
      }
      if(thermal_canvas.className.includes("fullscreen")){
        toggleFullScreen("thermal_canvas");
      }
    }
}
  
function toggleFullScreen(type){
  thermal_canvas.parentElement.style.display = "none";
  hd_canvas.parentElement.style.display = "none";

  let canvas = document.getElementById(type);
  let container = document.getElementById(type).parentElement;

  // Enable fullscreen
  if(canvas.className === "camera-canvas"){
      container.style.display = "";
      container.classList.add("camera-container-fullscreen");
      container.classList.remove("camera-container");
      canvas.classList.toggle("camera-canvas-fullscreen");
      document.getElementById("buttons").style.display = "none";

  }
  // Disable fullscreen
  else{
      canvas.classList.remove("camera-canvas-fullscreen");
      container.classList.add("camera-container");
      container.classList.remove("camera-container-fullscreen");
      thermal_canvas.parentElement.style.display = "";
      hd_canvas.parentElement.style.display = "";
      document.getElementById("buttons").style.display = "";
  }
}

document.addEventListener("keydown", handleEscapeKeyPress);
