def writeInFormat(varName: str, dataInBytes: bytearray):
	varNameLength = len(varName)
	dataLength = len(dataInBytes)

	data = bytearray()
	data.extend(varNameLength.to_bytes(4, 'big'))
	data.extend(bytes(varName, 'utf-8'))

	data.extend(dataLength.to_bytes(4, 'big'))
	data.extend(dataInBytes)

	return data

def readInFormat(data: bytearray):
	variables = []
	while len(data):
		varNameLength = int.from_bytes(data[0:4], 'big')
		varName = data[4:4+varNameLength].decode('utf-8')
		dataLength = int.from_bytes(data[4+varNameLength:8+varNameLength], 'big')
		dataBuf = data[8+varNameLength:8+varNameLength+dataLength]

		variables += [{
			"varName": varName,
			"data": dataBuf
		}]

		data = data[8+varNameLength+dataLength:]
	return variables

if __name__ == '__main__':
	x = writeInFormat("tes", bytes("test2", 'utf-8'))
	y = writeInFormat("something else", (12345).to_bytes(4, 'big'))
	print(x)
	print(y)

	data = x + y
	variables = readInFormat(data)
	print(variables)
