#include <SparkFun_TB6612.h>
#include <Adafruit_NeoPixel.h>
#include <Servo.h>

#ifdef __AVR__             //Littyy ledien setuppiin
 #include <avr/power.h>
#endif

#define LedPin_1  53       //Pistetään jokaiselle käyettävällä arduinon pinille niiden käyttötarkoitus
#define SensorPin_1  52     //Tiedetään tarkasti vasta juottamisen jälkeen
#define ServoPin_1  50
#define SwitchPin_1 51

#define LedPin_2  47
#define SensorPin_2   46
#define ServoPin_2  44
#define SwitchPin_2 45

#define LedPin_3   38 
#define SensorPin_3  41
#define ServoPin_3  39
#define SwitchPin_3  40

#define LedPin_4  35
#define SensorPin_4  32 
#define ServoPin_4   33
#define SwitchPin_4  34

#define LedPin_5   29
#define SensorPin_5  26
#define ServoPin_5  27 
#define SwitchPin_5  28

#define LedPin_6   22
#define SensorPin_6   24
#define ServoPin_6  25
#define SwitchPin_6  23
  
Adafruit_NeoPixel LeftLed = Adafruit_NeoPixel(16, 14, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel RightLed = Adafruit_NeoPixel(16, 18, NEO_GRB + NEO_KHZ800);



class Muki    //Luodaan uusi mukiolio, jossa säilyy tieto siihen liitetystä servosta, ledistä ja kahdesta input kytkimestä
{
 public:                     //Tässä kohtaa säilytetään tietoa liitetyistä pineistä, ledistä ja servosta
 byte LedPin;
 byte ServoPin;
 byte SwitchPin;              
 byte SensorPin;
 
 int TimeToDownPosition = 1300;  //Arvioitu aika, jona muki liikkuu sopivasti pöydän sisään. Tätä voidaan muuttaa vielä esimerkiksi setup-funktiossa komennolla "muki_x.TimeToDownPosition = X"
 int LedCount = 4;
 int Hit = 0;
 int BrakeValue;
 byte pos;  //Position of cup. 0 = Down, 1 = Up
 Servo servo;       //Ledit ja servo ovat luotu omina erillisinä olioina
 Adafruit_NeoPixel pixels;
 
 Muki(byte LedPin, byte SensorPin, byte ServoPin, byte SwitchPin, int BrakeValue)  //Funktio, joka toteutetaan luodessa tätä oliota
   {                                                              //Funktiossa pistetään arduinon pinit toimintavalmiuteen ja valmistellaan lediolio ja servo-olio käyttövalmiuteen
     this->LedPin = LedPin;             //Näissä luultavasti pistetään saatu arvo vanhojen arvojen paikalle
     this->SensorPin = SensorPin;
     this->ServoPin = ServoPin;
     this->SwitchPin = SwitchPin;
     this->BrakeValue = BrakeValue;
     pinMode(LedPin, OUTPUT);
     pinMode(SensorPin, INPUT);
     pinMode(ServoPin, OUTPUT);
     pinMode(SwitchPin, INPUT);
     this->servo = servo;
   }


   void LedBegin()         // Ledien setup funktio
   {
    pixels = Adafruit_NeoPixel(LedCount, LedPin, NEO_GRB + NEO_KHZ800);
    pixels.begin();
   }
  
  void LedColorChange(int Red, int Green, int Blue)  //Funktio kaikkien ledin värien vaihtamiseksi halutun väriseksi
  {
    for(int i=0; i<LedCount; i++)
    {
      pixels.setPixelColor(i, Red, Green, Blue);
      pixels.show();
    }
  }

  void Calibration()               //Funktio, jossa muki nousee pöydästä, kunnes osuu kytkimeen, jolloin se pysähtyy. Yllättäen vaati toimiakseen kytkimen.
  {
    int buttonstate = digitalRead(SwitchPin);
    servo.write(180);
    while(buttonstate == LOW)
    {
      buttonstate = digitalRead(SwitchPin);
    }
    servo.write(BrakeValue);
    pos = 1;
    return NULL;
  }

  void DownPosition()             //Funktio, jossa muki laskeutuu valmiiksi määritellyn ajan. Tämä aika on arvio ja voi vaihdella eri mukien välillä. Voidaan vielä määritellä jokaiselle mukille erikseen vielä setup-funktiossa
  {
    if(pos == 0)                //Hyppää funktion yli, mikäli kuppi on jo ala-asennossa
    {
      return NULL;
    }
    servo.write(0);
    delay(TimeToDownPosition);
    servo.write(BrakeValue);
    pos = 0;
    
  }

  void AttachPinToServo(int Pin)
  {
    servo.attach(Pin);
  }

  void down()
  {
    servo.write(0);
  }

  void stops()
  {
    servo.write(BrakeValue);
  }

  void up()
  {
    servo.write(180);
  }

  void kytkintesti()
  {
    while(digitalRead(SwitchPin) == LOW)
    {
    }
  Serial.print("kalibroitu\n");
  }

  void sensoritesti()
  {
    while(digitalRead(SensorPin) == HIGH)
    {
    }
  Serial.print("osuma");
  }
}; 

byte red;              //Luodaan globaaleja muuttujia, joiden avulla voidaan vaihtaa "tiimejä" eli mukeissa olevia värejä
byte green;
byte blue;

byte red_team_1 = 125;
byte green_team_1 = 23;
byte blue_team_1 = 145;

byte red_team_2 = 0;
byte green_team_2 = 33;
byte blue_team_2 = 180;



Muki muki_1(LedPin_1, SensorPin_1, ServoPin_1, SwitchPin_1, 90);      //Luodaan globaalisti 6 eri mukioliota
Muki muki_2(LedPin_2, SensorPin_2, ServoPin_2, SwitchPin_2, 90);
Muki muki_3(LedPin_3, SensorPin_3, ServoPin_3, SwitchPin_3, 90);      
Muki muki_4(LedPin_4, SensorPin_4, ServoPin_4, SwitchPin_4, 95);
Muki muki_5(LedPin_5, SensorPin_5, ServoPin_5, SwitchPin_5, 90);     
Muki muki_6(LedPin_6, SensorPin_6, ServoPin_6, SwitchPin_6, 95); 





Muki list[] = {muki_1, muki_2, muki_3, muki_4, muki_5, muki_6};  //Lista, joka helpottaa olioiden läpikäymistä    !Luo täysin uudet oliot! 
                                                                 //Jostain syystä servojen toimintaa tämä ei haittaa, mutta valot eivät tule toimimaan, jos käyttää sekä listaa että erillisiä olioita keskenään

void CalibrationForAll()                                         //Funktiolla saadaan kaikki kupit yläasentoon
{
  for(int i = 0; i < 6; i++)
  {
    list[i].Calibration();
    list[i].LedColorChange(red, green, blue);
  }
  Serial.print("All calibrated\n");
}

void AllDown()                                                   //Funktiolla saadaan kaikki kupit ala-asentoon. Ei tarvetta itse pelissä
{
  for(int i = 0; i < 6; i++)
  {
    list[i].DownPosition();
  }
  LedChange();
  Serial.println("All Down\n");
}


void DetectingBall()                                           //Funktio, joka toimii korkeitaan HowLongDetectingin määrittelemän ajan. Tämän ajan käy läpi sensoreita ja katsoo onko johonkin näistä osuttu.
{
  unsigned long StartTime = millis();
  unsigned long HowLongDetecting = 6000;                       //Kuinka pitkään luetaan osumaa, kunnes lopetetaan
  unsigned long TimeCheck;
  int Hit = 0;
  int buttonstate = 0;
  int HitMuki = 0;
  while(Hit == 0)
  {
    for(int i = 0; i < 6; i++)
    {
      if(digitalRead(list[i].SensorPin) == LOW)
      {
        list[i].Hit = 1;
        list[i].LedColorChange(255, 0, 0);
        delay(500);
        Serial.println(i+1);                                  //Kupin numero Raspberrylle
        return;
      }
    }
    unsigned long TimeSinceStart = millis() - StartTime ;
    if(TimeSinceStart >= HowLongDetecting)
    {
      delay(500);
      Serial.println(0);
      return;
    }
  }
}


void HitPosCheck()                                             //Käy läpi onko mukin osuma muuttuja ja positio muuttuja oikein. Eli, jos mukiin on osuttu, mukin ei kuuluisi olla ylhäällä ja laskeutuu
{
  for(int i = 0; i < 6; i++)
  {
    if(list[i].Hit == 0 and list[i].pos == 0)
    {
      list[i].Calibration();
    }
    else if(list[i].Hit == 1 and list[i].pos == 1)
    {
      list[i].DownPosition();
    }
  }
  LedChange();
  Serial.print("Done\n");
}


void ChangeTeam()                                                 //Funktiossa muutetaan Raspberryltä tulevat stringit numeroiksi, jotka määrittävät mukien Hit muuttujat tiimien tilannetta vastaavaksi.
{                                                                 //Stringien täytyy olla muotoa "010101"
  Serial.readString();                                            //Lukee ylimääräiset käskyt pois
  Serial.println("Ready");                                        //Funktio suoritetaan toisen pelaajan ammuttua. Tämän takia "tiimiä" vaihdetaan tämän funktion lopussa ChangeTeamColor funktiolla
  while(Serial.available() == 0)
  {
  }
  int intNum;
  String tilanne = Serial.readString();
  for(int i = 0; i < 6; i++)
  {
    char letter = tilanne.charAt(i);
    if(letter == '0')
    {
      intNum = 0;
    }
    else if(letter == '1')
    {
      intNum = 1;
    }
    list[i].Hit = intNum;
  }
  ChangeTeamColor();   
  SideLedChange(red, green, blue);
  HitPosCheck();                  //Tällä funktiolla vielä muutetaan kuppien asennot tilannetta vastaavaksi
}

void ChangeTeamColor()  //Vaihtaa nykyisen värin tilalle toisen tiimin värin
{
  if(red == red_team_1)
  {
    red = red_team_2;
    green = green_team_2;
    blue = blue_team_2;
  }
  else
  {
    red = red_team_1;
    blue = blue_team_1;
    green = green_team_1;
  }
}



void LedChange()   //Muuttaa ledien värejä sen mukaan onko mukeihin osuttu ja kumman tiimin vuoro on
{
  for(int i = 0; i<6; i++)
  {
    if(list[i].Hit == 0)
    {
      list[i].LedColorChange(red, green, blue);   //Globaaleja muuttujia, jotka vaihtuvat aina ChangeTeam funktion jälkeen.
    }
    else
    {
      list[i].LedColorChange(255, 0, 0);
    }
  }
}

void SideLedPower()         //Funktio, jolla määritellään kuinka monta sivulediä mahdollisesti palaa. 
{
  String LedNum = Serial.readStringUntil('\n');  
  int IntLedNum = LedNum.toInt();
  int punainen = round(red/10);
  int vihrea = round(green/10);
  int sininen = round(blue/10);
  int Max = 16 - IntLedNum;
  for(int i = 15; i >= Max; i--)  //Määritellään palavat ledit
  {
    LeftLed.setPixelColor(i, punainen, vihrea, sininen);      // Tässä voidaan määritellä ledien kirkkautta. Tällä hetkellä pieni kirkkaus, jotta kamera näkisi nämä paremmin
    RightLed.setPixelColor(i, punainen, vihrea, sininen);
    LeftLed.show();
    RightLed.show();
  }
  for(int i = 0; i < Max; i++)    //Määritellään muut ledit, jotta vanhat värit eivät jää päälle. Tällä hetkellä määritellään sammuneiksi. Voidaan määrittää kuitenkin minkä värisiksi tahansa.
  {
    LeftLed.setPixelColor(i, 0, 0, 0);
    RightLed.setPixelColor(i, 0, 0, 0);
    LeftLed.show();
    RightLed.show();
  }
}


//Seuraaville kahdelle funktiolle ei oikeastaan ole ollut tarvetta
void HitSituationBack()           //Lähettää takaisin Raspberryn oman Hit tilanteen
{
  for(int i = 0; i < 6; i++)
  {
    Serial.print(list[i].Hit);
  }
}

void PosSituationBack()           //Lähettää takaisin Raspberryn oman pos tilanteen 
{
  for(int i = 0; i < 6; i++)
  {
    Serial.print(list[i].pos);
  }
}




void ledtesti()         //Testausfuktio, jolla nähdään ledien toimivuus                   
{
  for(int i= 0; i<6; i++)
  {
    list[i].LedColorChange(0, 0, 255);
  }
  SideLedChange(0, 255, 255);
}

void kytkintestaus()  //Testausfunktio, kytkimet käydään yksitellen läpi
{
  for(int i = 0; i < 6; i++)
  {
    list[i].kytkintesti();
    list[i].LedColorChange(0, 255, 0);
  }
}

void anturitesti()   //Testausfunktio, sensorit käydään yksitellen läpi 
{
  for(int i = 0; i < 6; i++)
  {
    list[i].sensoritesti();
    Serial.print(i);
    Serial.print(" Osuttu\n");
  }
}

void ylos()     //Testausfunktio, kaikki servot pyörivät ylöspäin samaan aikaan
{
  for(int i = 0; i < 6; i++)
  {
    list[i].up();
  }
  delay(300);
  for(int i = 0; i < 6; i++)
  {
    list[i].stops();
  }
}

void servotesti()    //Testausfunktio, jossa servot liikkuvat alaspäin
{
  for(int i = 0; i < 6; i++)
  {
    list[i].down();
  }
  delay(1000);
  for(int i = 0; i < 6; i++)
  {
    list[i].stops();
  }
}

void SideLedChange(int R, int G, int B)           //Sivuledien kirkkauden ja värien säätö
{
  for(int i=0; i<16; i++)
    {
      int punainen = round(R/10);
      int vihrea = round(G/10);
      int sininen = round(B/10);
      LeftLed.setPixelColor(i, LeftLed.Color(punainen, vihrea, sininen));
      LeftLed.show();
      RightLed.setPixelColor(i, RightLed.Color(punainen, vihrea, sininen));
      RightLed.show();
      
      
      
      
    }
}

void setup()
{
  Serial.begin(115200);
  muki_1.servo.attach(ServoPin_1);   //Servojen pinit täytyy liittää setup-funktiossa. Muute servot bugaavat ja pyörivät loputtomiin yhteen suuntaan
  muki_2.servo.attach(ServoPin_2);
  muki_3.servo.attach(ServoPin_3);
  muki_4.servo.attach(ServoPin_4);
  muki_5.servo.attach(ServoPin_5);
  muki_6.servo.attach(ServoPin_6);

  for(int i = 0; i<6; i++)   //"Aloitetaan" ledit. Ei mittää hajuu kui maar ni täytyy tehrä
  {
    list[i].LedBegin();
  }

  red = red_team_1;         //alustetaan värit ensimmäisen tiimin väreillä
  blue = blue_team_1;
  green = green_team_1;
  
  LeftLed.begin(); 
  RightLed.begin();
  SideLedChange(red, green, blue);

  for(int i = 0; i<6; i++)                  //For loopissa määritellään jokaiselle mukille oma laskeutumis aika. Jotkut servot päästävät mukin valumaan vielä hieman jarruttaessaan ja jotkut pyörivät hitaammin kuin toiset. Lukuarvot löytyvät vain kokeilemalla.
  {                                         
    switch(i)                               //Tämän voi helpomminkin tehdä, mutta tämä nyt vaan toimii
    {

      case 0:
      list[i].TimeToDownPosition = 1400;
      break;
      
      case 1:
      list[i].TimeToDownPosition = 1350;
      break;

      case 2:
      list[i].TimeToDownPosition = 1050;
      break;

      case 3:
      list[i].TimeToDownPosition = 1400;
      break;

      case 4:
      list[i].TimeToDownPosition = 1400;
      break;

      case 5:
      list[i].TimeToDownPosition = 1400;
      break;

    }
  }

  

  Serial.print("Setup complete\n");
}



void loop()                // Loop funktio käy läpi serialiin tulevia käskyjä ja suorittaa funktioita näiden mukaan
{
  if(Serial.available() > 1)                     
  {
    char Command = Serial.read();
    switch(Command)
    {

      case 'd':
      Serial.read();
      DetectingBall();
      break;

      case 't':
      Serial.read();
      ChangeTeam();
      break;

      case 'c':
      Serial.read();
      CalibrationForAll();
      break;

      case 'l':
      SideLedPower();
      break;


//Seuraavat funktiot ovat mukien testaukseen arduinon avulla
/*
      case 'y':
      ylos();
      break;
      
      case 'a':
      servotesti();         //Laskee kaikkia mukeja alaspäin
      break;
*/
      case 'b':
      AllDown();
      break;
      
      default:
      break;
    }
  }
}
