
-- luacheck: globals gServer
gServer = TCPIPServer.create()
if not gServer then
  print('Could not create TCPIPServer')
end
TCPIPServer.setPort(gServer, 2120)
TCPIPServer.setFraming(gServer, '\02', '\03', '\02', '\03') -- STX/ETX framing for transmit and receive
TCPIPServer.register(gServer, 'OnConnectionAccepted', 'gHandleConnectionAccepted')
TCPIPServer.register(gServer, 'OnConnectionClosed', 'gHandleConnectionClosed')
TCPIPServer.listen(gServer)

local connection

-- luacheck: globals gHandleConnectionAccepted
function gHandleConnectionAccepted(con)
  print('New connection: ' .. con) -- Print to console when new connections arrive
  connection = con -- Store the latest connection for index transmitting
  TCPIPServer.Connection.transmit(con, 'Hello!') -- If a client successfully connects, transmit a hello message
end

-- luacheck: globals gHandleConnectionClosed
function gHandleConnectionClosed(con)
  print('A connection is closed: ' .. con) -- Print to console if someone disconnects
end

local function handleOnIndexChange(index) -- Sends the parameter to the latest connection
  if connection ~= nil and TCPIPServer.Connection.isConnected(connection) then
    TCPIPServer.Connection.transmit(connection, tostring(index))
  end
end
Script.register('pointMatcher.OnIndexChange', handleOnIndexChange) -- Registers the script for use from other apps
