-- Image teach region x,y
local x = 960/4
local y = 1280/4

-- Defining teach object position and teach region
local objectCorners = {
  Point.create(x, y, 0),
  Point.create(3*x, y, 0),
  Point.create(3*x, 3*y, 0),
  Point.create(x, 3*y, 0)
}

--local teachShape = Shape.createPolyline(objectCorners, false)
local teachShape = Shape3D.createPolygon(objectCorners)

--[[  KAMERA
  konfigurointi]]--
local camera = Image.Provider.Camera.create()

local config = Image.Provider.Camera.V2DConfig.create()
config:setBurstLength(0) -- Continuous acquisition
config:setFrameRate(1) -- Hz
config:setShutterTime(780) -- us
config:setGainFactor(7)

camera:setConfig(config)
-------------------------------------------------------
local DELAY = 1000 -- viivästys visualisointia varten
local MATCH_THRESHOLD = 0.5 -- millä todennäköisyydellä matchit otetaan huomioon (välillä 0..1)
local EMPTY_THRESHOLD =  5000 -- kuinka monta valoisaa pikseliä kuvassa tulee olla, jotta se matchataan
local OBJECT_PIXEL_TRESHOLD = 100 -- mikä lasketaan "valoisaksi pikseliksi"
local LIVEIMAGEID = 'LIVEIMAGEID' -- globaali kuvan id mahdollistaa kuvan poistamisen poistamatta alueen rajausta
--matcherin asetukset--
local POINT_COUNT = 700
local ITERATIONS = 500
local DOWNSAMPLE_FACTOR = 5
local POSE_VARIABILITY = 'LOW'
local POSE_TYPE = 'RIGID'
local function outputConsole(str)
  local output = str .. "\n"
  Script.notifyEvent("OnNewConsoleText", output)
end
-- Tallentaa tietyn kuvan asetukset
local function saveSettings(timestamp)
  -- Tee kansio, jos sitä ei vielä ole
  File.mkdir("public/teachSettings")
  -- Luo tiedosto
  local handle = File.open("/public/teachSettings/settings-" .. timestamp .. ".txt", "w")
  -- Kirjoita asetukset tiedostoon
  handle:write("" .. POINT_COUNT .. " " .. ITERATIONS .. " " .. DOWNSAMPLE_FACTOR .. " " .. POSE_VARIABILITY .. " " .. POSE_TYPE)
  -- Sulje tiedosto (tallentaa sen)
  handle:close()
end

-- Lukee parametrinä annetun kuvan asetukset
local function readSettings(imagepath)
  -- Etsii kuvan tiedostopolun. Kuvan asetuksilla on sama nimi
  local filepath = {}
  local imagepathIterator = string.gmatch(imagepath, "([^.]*)")
  for i in imagepathIterator do
    table.insert(filepath, i)
  end
  print("reading from " .. filepath[1])
  -- Avaa asetustiedoston ja lukee asetukset
  local file = File.open("/public/teachSettings/settings-" .. filepath[1] .. "." .. filepath[2] .. ".txt", "rb")
  local data = File.read(file)
  local settings = {}
  local iterator = string.gmatch(data, "%S+")
  for i in iterator do
    table.insert(settings, i)
  end
  -- Asettaa asetukset luetusta datasta
  POINT_COUNT = tonumber(settings[1])
  ITERATIONS = tonumber(settings[2])
  DOWNSAMPLE_FACTOR = tonumber(settings[3])
  POSE_VARIABILITY = settings[4]
  POSE_TYPE = settings[5]
end

--referenssimallit----
local models = {}

-- Creating viewer
local viewer = View.create()
viewer:setID('viewer2D')

-- Decorations
local teachDecoration = View.ShapeDecoration.create()
teachDecoration:setPointSize(10)
teachDecoration:setLineColor(0, 0, 255) -- Blue color scheme for "Teach" mode
teachDecoration:setPointType('DOT')
teachDecoration:setLineWidth(5)

local teachRegionDecoration = View.PixelRegionDecoration.create()
teachRegionDecoration:setColor(0, 0, 255, 40)

local foundRegionDecoration = View.PixelRegionDecoration.create()
foundRegionDecoration:setColor(0, 255, 0, 40)

local foundDecoration = View.ShapeDecoration.create()
foundDecoration:setPointSize(10)
foundDecoration:setLineColor(0, 255, 0) -- Green color scheme for "Found" mode
foundDecoration:setPointType('DOT')
foundDecoration:setLineWidth(5)

local txtDecoration = View.TextDecoration.create()
txtDecoration:setColor(0, 0, 255)
txtDecoration:setSize(130)

--End of Global Scope-----------------------------------------------------------

--Start of Function and Event Scope---------------------------------------------
local savingOn = false -- boolean joka asetetaan true, mikäli halutaan, että kuva tallennetaan
local initializationOn = false -- boolean joka asetetaan true, mikäli halutaan että kuvia ei tallenneta (toggle)
local teachAreaEnabled = false -- Boolean, joka kertoo, onko teach area näkyvillä näytöllä tällä hetkellä


local function updateImage(img)
  viewer:remove(LIVEIMAGEID)
  viewer:addImage(img, nil, LIVEIMAGEID)
  viewer:present()
end
-- Opetusalueen tallentamiseen
local function saveTeachShape(object_corners, filename)
  -- luodaan kansio opetusalueille
  File.mkdir("public/teachShapes")
  -- luodaan tekstitiedosto koordinaatteja varten, (filename on timestamp, eli sama kuin tallennetulla kuvalla)
  local handle = File.open("/public/teachShapes/shape-" .. filename .. ".txt", "w")
  if handle==nil then
    return false
  else
    local str=""
    -- käydään tämänhetkiset hetkiset opetusalueen määrittävät pisteet läpi ja tallennetaan tiedostoon
    for i=1,4 do
      local xcoord,ycoord=object_corners[i]:getXY()
      if i==4 then
        str=str..xcoord..","..ycoord
      else
        str=str..xcoord..","..ycoord..";"
      end
    end
    -- KIRJOITETAAN TIEDOSTON ALKUUN KÄYTETÄÄNKÖ MANUAALISTA OPETUSALUETTA VAI AUTOMAATTISTA TUNNISTUSTA
    local dismiss=teachAreaEnabled
    handle:write(tostring(dismiss)..";"..str.."\n")
    handle:close()
    return true
  end
end
-- Tallennetun opetusalueen käyttämiseen ladattaessa ja opetettaessa valmiiksi otettuja kuvia
local function setSavedShape(imagepath)
  local filepath = {}
  local imagepathIterator = string.gmatch(imagepath, "([^.]*)")
  for i in imagepathIterator do
    table.insert(filepath, i)
  end
  print("fetching shape from file: " .. filepath[1])
  -- Avaa opetusalueen kulmapisteet sisältävän tekstitiedoston ja luo opetusalueen niistä
  local file = File.open("/public/teachShapes/shape-" .. filepath[1] .. "." .. filepath[2] .. ".txt", "r")
  local data = File.read(file)
  local object_corners = {}
  local function split(str, separator)
    local t = {}
    local pattern = string.format("([^%s]+)", separator)
    string.gsub(str, pattern, function(a) t[#t + 1] = a end)
    return t
  end
  local iterator = split(data,";")
  local head=table.remove(iterator, 1)
  print(head)
  if head=="true" then teachAreaEnabled=true else teachAreaEnabled=false end
  for i=1,#iterator do
    local  table = split(iterator[i], ",")
    local xcoord=table[1]
    local ycoord=table[2]
    object_corners[i]=Point.create(tonumber(xcoord),tonumber(ycoord),0)
  end
  objectCorners=object_corners
end
-- Tämä eventti bindattu UI:n indeksilistaan, päivittyy aina uuden teachin yhteydessä
Script.serveEvent("pointMatcher.IndexListAdd", "IndexListAdd", "string")
-- Indeksilistan rakennusfunktio, (KUN EI VIELÄ MATCHATA!)
--@updateIndexlist():string
local function updateIndexlist()
  local str = ""
  
  for i=1,#models do
    --local path = "/public/runtimeImages/"..i..".bmp"
    --print(path)
    --local img = Image.load(path)
    
    str = str .. "OBJECT ".. i .. "  "
    --str = str .. "<a href="..path.." target=\"_blank\">show image</a>"
    str = str .. "<br>"
  end
  
  Script.notifyEvent("IndexListAdd", str)
end
--@teach(img:Image)
local function teach(img) -- OPETUSALGORITMI
  camera:deregister('OnNewImage', teach) --ettei aloita uutta opetusta

  local console_output= "Aloitetaan opettaminen.<br>Asetukset:<br>".."point count: " .. POINT_COUNT .. "<br>iterations: " .. ITERATIONS .. "<br>downsamplefactor: " .. DOWNSAMPLE_FACTOR .. "<br>pose variability: " .. POSE_VARIABILITY .. "<br>posetype: " .. POSE_TYPE

  local id = viewer:addImage(img)
  local starttime = DateTime.getTimestamp()
  local matcher = Image.Matching.PointMatcher.create() -- yksilöllinen matcher joka teachille

  --matcherin konfigurointi
  matcher:setPoseType(POSE_TYPE) -- mahdollista tunnistaa eri perspektiivistä
  matcher:setPoseVariability(POSE_VARIABILITY)
  matcher:setDownsampleFactor(DOWNSAMPLE_FACTOR)
  matcher:setPointCount(POINT_COUNT)
  matcher:setIterations(ITERATIONS)
  print(type(objectCorners[1]))
  local shape=Shape3D.createPolygon(objectCorners)
  local teachRegion = shape:toPixelRegion(img)

  if not teachAreaEnabled then
    --suoritetaan automaattinen opetusalueen tunnistus
    local objectRegion = img:threshold(OBJECT_PIXEL_TRESHOLD, 255)
    teachRegion = objectRegion:findConnected(10000)[1]
  else
    local matrix = Matrix.createFromVector({1,0,0,0,-1,0,0,0,1}, 3, 3)
    local transform = Transform.createFromMatrix2D(matrix)
    local com = Image.PixelRegion.getCenterOfGravity(teachRegion, img)
    local similarityTransform = Transform.createSimilarity2D(0, 1, 0, -1200, com)
    local composedTransform = Transform.compose(similarityTransform, transform)
    teachRegion = teachRegion:transform(composedTransform, img)
  end

  viewer:addPixelRegion(teachRegion, teachRegionDecoration, 'teachRegion', id)
  -- Teach the matcher and store the teach pose
  local teachpose = matcher:teach(img, teachRegion)
  -- Tunnistuspisteiden esittäminen kuvassa
  local modelPoints = matcher:getModelPoints() -- Model points in model's local coord syst
  local teachPoints = Point.transform(modelPoints, teachpose)
  for _, pt in pairs(teachPoints) do
    viewer:addShape(pt, teachDecoration, nil, id)
  end
  --yksilöllisen matcherin tallentaminen referenssimalleihin
  local model = {matcher = matcher, tunnistusAlue = teachRegion, tunnistusMuoto = teachShape}
  models[#models+1] = model

  -- Jos käynnissä ei ole opetuskuvien lataaminen kansiosta ja savingOn==true, tallennetaan teach
  
  if not initializationOn and savingOn==true then
    -- KUVAN TALLENNUS --
    -- Tehdään uusi teachImg kansio, ellei sitä jo ole olemassa
    File.mkdir("public/teachImg")
    -- Luodaan kuvalle semi-uniikki nimi nykyisellä timestampilla
    local filename = DateTime.getDateTime()
    local path1 = "public/teachImg/" .. filename .. ".bmp"
    -- Jos sattuu erittäin huono tuuri, ja nykyinen timestamppi on käytetty (aika resettaa kameran asetuksissa aina kun sen käynnistää uudelleen)
    -- Tällöin luodaan satunnainen luku nimeksi nollan ja miljoonan välillä
    if (File.exists(path1)) then
      filename=tostring(math.random(1000000))
      path1 = "public/teachImg/" .. filename .. ".bmp"
    end
    -- Tallennetaan nykyiset asetukset timestampilla
    saveSettings(filename)
    -- Tallennetaan kuva
    img:save(path1)
    -- TEACHSHAPEN TALLENNUS --
    local ret=saveTeachShape(objectCorners, filename)
    print("managed to save teachshape: "..tostring(ret))
  end
  local endtime = DateTime.getTimestamp()
  console_output= console_output .. '<br>Teach time: ' .. tostring(endtime - starttime) .. ' ms'  -- tulostaa ajan, joka opettamiseen meni
  outputConsole(console_output)
  viewer:present()
  viewer:remove(id)
  -- opetuskuvien ajonaikainen tallennus (EI TOIMI KOSKA NÄITÄ KUVIA EI SAA NOUDETTUA HTML-KOODIN KAUTTA)
  File.mkdir("/public/runtimeImages")
  local runtime_id = #models
  local impath="/public/runtimeImages/"..tostring(runtime_id)..".bmp"
  print(impath)
  local ret = img:save("/public/runtimeImages/"..tostring(runtime_id)..".bmp") --indeksilistaan liitettävän kuvan tallennus
  
  -- Kutsutaan vielä indeksilistan rakennusfunktiota, lista päivittyy nyt uudella indeksillä
  updateIndexlist()

end
local function match(img) --TUNNISTUS-ALGORITMI
  
  local matchScores={}
  local matchPoses={}
  local starttime = DateTime.getTimestamp()

  for i=1,#models do
    local matcher=models[i].matcher
    local pose, score = matcher:match(img)
    matchScores[i]=score[1]
    matchPoses[i]=pose[1]
  end
  
  local maxindex = 1
  for j = 1, #matchScores do
    if (matchScores[j] > matchScores[maxindex]) then
      maxindex = j
    end
  end

  if matchScores[maxindex] > MATCH_THRESHOLD then
    local endtime = DateTime.getTimestamp()
    outputConsole('Match found with index '.. maxindex..'<br>in time ' .. tostring(endtime - starttime) .. ' ms<br>with score: '..matchScores[maxindex])
    local matcher = models[maxindex].matcher
    local pose = matchPoses[maxindex]
    
    local modelPoints = matcher:getModelPoints() -- matching points in model's local coord syst
    local matchPoints = Point.transform(modelPoints, pose)  -- moves matching points to the region where they were found in the live image
    for _, pt in pairs(matchPoints) do
      viewer:addShape(pt, foundDecoration, nil, LIVEIMAGEID)
    end
    viewer:present()
    return maxindex
  else
    outputConsole('match score ('..matchScores[maxindex]..') did not pass the treshold')
    return -1 -->ö-mappiin
  end
end
-- MAIN --
local function main()
  viewer:clear()
  camera:enable()
  camera:start()
end
-----------
local function matchCurrent(img)
  -- Otetaan pikselit, joiden arvo on 200 tai yli
  local thresh = img:threshold(OBJECT_PIXEL_TRESHOLD, 255)
  print("Pixel count is " .. thresh:countPixels())
  -- Jos pikselien määrä kuvassa on yli asetetun rajan
  -- JA on jo opetettu vähintään yksi referenssikuva...
  if (thresh:countPixels() > EMPTY_THRESHOLD and next(models) ~= nil) then
    --- ...on kameran kuvassa jotain ja se matchataan
    local idx = match(img)
    -- Lähetetään lehden indeksi TCPIP appiin
    Script.notifyEvent('OnIndexChange', idx)
  else
    -- Jos pikselien määrä on alle asetetun rajan, ei kuvaa matchata
    outputConsole("A: No objects detected or no models taught")
    updateIndexlist()
    viewer:clear()
    viewer:addImage(img)
    viewer:present()
  end
end
local function OnChange(iconicId, iconic)
  teachShape = iconic
  print("Updated rectangle:" .. iconicId)
  local polyline = teachShape:toShape3D()
  local points = Shape3D.getPolygonParameters(polyline)--Shape3D.getPolylineParameters(polyline)
  
  for i=1,4 do
    local xcoord,ycoord=points[i]:getXY()
    print(tostring(xcoord)..", "..tostring(ycoord))
    
    objectCorners[i]=Point.create(xcoord, ycoord,0)
  end
  print("\n")
  
end
--------- UI-ELEMENTIT -----------------
local curIndex = -1
local function startMatching()
  camera:register('OnNewImage', matchCurrent)
  outputConsole("Started matching")
end
local function endMatching()
  camera:deregister('OnNewImage', matchCurrent)
  updateIndexlist()
  curIndex = -1
  outputConsole("Matching ended")
end

local function teachCurrent()
  camera:register('OnNewImage', teach)
end
Script.serveFunction("pointMatcher.endMatching", endMatching)
Script.serveFunction("pointMatcher.startMatching", startMatching)
Script.serveFunction("pointMatcher.teachCurrent", teachCurrent)

--@setSavingOn(var1:bool):
local function setSavingOn (var1) --SÄÄTÄÄ ONKO TEACHIEN TALLENNUS PÄÄLLÄ VAI EI
  savingOn=var1
  print("Saving turned to: "..tostring(savingOn))
end
Script.serveFunction("pointMatcher.setSavingOn", setSavingOn)
local function clearSavedData()
  local ret=File.del("/public/teachImg")
  local ret2=File.del("/public/teachSettings")
  local ret3=File.del("/public/teachShapes")
  if ret==true and ret2==true and ret3==true then
    outputConsole("succeeded in deleting previous files")
  else
    outputConsole("error in deleting files")
  end
end
Script.serveFunction("pointMatcher.clearSavedData", clearSavedData)
-- Opetetaan kaikki tallennetut kuvat uudelleen
local function teachSaved()
  local files = File.list("/public/teachImg")
  initializationOn = true
  local retainShape=teachAreaEnabled
  if files ~= nil and #files ~= 0 then
    for i = 1, #files do
      print("teaching image at " .. files[i])
      local path = "/public/teachImg/" .. files[i]
      local image = Image.load(path)
      -- Ladataan asetukset, jotka vastaa kuvaa, tiedostosta
      readSettings(files[i])
      -- Ladataan opetusalue, joka oli kuvan opetushetkellä opetusalueena, tiedostosta
      setSavedShape(files[i])
      teach(image)
    end
  else
    outputConsole('Did not find saved models')
  end
  initializationOn=false
  teachAreaEnabled=retainShape
end
Script.serveFunction("pointMatcher.teachSave", teachSaved)
--@setTeachArea(var1:bool):
local function setTeachArea (var1)
  if not var1 then
    viewer:clear()
    teachAreaEnabled = false
  else -- Jos teach area ei ole päällä, laita se päälle
    teachAreaEnabled = true
    viewer:addShape(teachShape, teachDecoration, "teachBox", 'refimage')
    viewer:installEditor("teachBox")
    viewer:present()
  end
end
Script.serveFunction("pointMatcher.setTeachArea", setTeachArea)
--MATCHERIN ASETUSTEN SÄÄTÖÖN AJON AIKANA--
--Määrittää näkyvätkö asetukset UI:ssa
--@showConfigs(var1:bool):
local function showConfigs (var1)
  return var1
end
Script.serveFunction("pointMatcher.showConfigs", showConfigs)

--@setPC(var1:int):
local function setPC (value)
  POINT_COUNT=value
end
Script.serveFunction("pointMatcher.setPC", setPC)

--@setIterations(var1:int):
local function setIterations (value)
  ITERATIONS=value
end
Script.serveFunction("pointMatcher.setIterations", setIterations)

--@setDownSampleFctr(var1:int):
local function setDownSampleFctr (value)
  DOWNSAMPLE_FACTOR=value
end
Script.serveFunction("pointMatcher.setDownSampleFctr", setDownSampleFctr)

--@setPoseVariability(var1:string):
local function setPoseVariability (str)
  print("Pose variability set to " .. str)
  POSE_VARIABILITY=str
end
Script.serveFunction("pointMatcher.setPoseVariability", setPoseVariability)

--@setPoseType(var1:string):
local function setPoseType (str)
  POSE_TYPE=str
end
Script.serveFunction("pointMatcher.setPoseType", setPoseType)

--@setEmptyThreshold(var1:int):
local function setEmptyThreshold (value)
  --print("setting empty threshold to " .. value)
  EMPTY_THRESHOLD = value
end
Script.serveFunction("pointMatcher.setEmptyThreshold", setEmptyThreshold)

--@setMatchThreshold(var1:int):
local function setMatchThreshold (value)
  --print("setting match threshold to " .. value/100)
  MATCH_THRESHOLD = value/100
end
Script.serveFunction("pointMatcher.setMatchThreshold", setMatchThreshold)
--@setObjectPixelValue(var1:int):
local function setObjectPixelValue (var1)
  OBJECT_PIXEL_TRESHOLD=var1
end
Script.serveFunction("pointMatcher.setObjectPixelValue", setObjectPixelValue)
--------------------------------------------------
--TCPIP:n yhdistäminen--
Script.serveEvent('pointMatcher.OnIndexChange', 'OnIndexChange', 'int')
Script.serveEvent("pointMatcher.OnNewStaticText", "OnNewStaticText","string")
Script.serveEvent("pointMatcher.OnNewConsoleText", "OnNewConsoleText","string")
Script.register('Engine.OnStarted', main)
camera:register('OnNewImage', updateImage)
viewer:register("OnChange", OnChange)
--End of Function and Event Scope--------------------------------------------------

-- Indeksilistanrakennus funktio matchingin ollessa päällä
local function buildStaticTextResult(selIdx)
  local str = ""
  -- listaa modelit
  for i=1,#models do
    -- kun listassa tulee vuoroon matchatty indeksi, lihavoi
    if i == selIdx then
      str = str .. "<mark><b><big>" .. "MODEL ".. i .. "</big></b></mark>"
    -- muuten pelkästään lisää
    else
      str = str .. "MODEL ".. i
    end
    str = str .. "<br>"
  end
  
  return str
end

--@handleOnExpired(var1: int)
local function handleOnExpired(var1)
  
  if var1 ~= curIndex then
    curIndex = var1
    print(curIndex)
    print(var1)
    local selectedIndex = var1
    -- kutsutaan indeksilistan rakennusfunktiota parametrina selectedIndex, joka on matchaava indeksi
    local staticText = buildStaticTextResult(selectedIndex) --paluuarvona siis indeksilista stringinä
    -- päivitetään lista (UI:n staticTextControl on bindattu reagoimaan tähän eventtiin)
    Script.notifyEvent("OnNewStaticText", staticText)
  end
end
Script.register('pointMatcher.OnIndexChange', handleOnExpired)






--@clearIndexlist(var1:int):
local function clearIndexlist ()
  models = {}
  updateIndexlist()
end
Script.serveFunction("pointMatcher.clearIndexlist", clearIndexlist)
