/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ir.server;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;

public class MonkeyPatcher {
    public static Object getActivityThread(Context context, Class<?> activityThread) {
        try {
            if (activityThread == null) {
                activityThread = Class.forName("android.app.ActivityThread");
            }
            Method m = activityThread.getMethod("currentActivityThread", new Class[0]);
            m.setAccessible(true);
            Object currentActivityThread = m.invoke(null, new Object[0]);
            if (currentActivityThread == null && context != null) {
                Field mLoadedApk = context.getClass().getField("mLoadedApk");
                mLoadedApk.setAccessible(true);
                Object apk = mLoadedApk.get(context);
                Field mActivityThreadField = apk.getClass().getDeclaredField("mActivityThread");
                mActivityThreadField.setAccessible(true);
                currentActivityThread = mActivityThreadField.get(apk);
            }
            return currentActivityThread;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static void monkeyPatchExistingResources(Context context, String externalResourceFile, Collection<Activity> activities) {
        if (externalResourceFile == null) {
            return;
        }
        try {
            Collection references;
            AssetManager newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method mAddAssetPath = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
            mAddAssetPath.setAccessible(true);
            if ((Integer)mAddAssetPath.invoke((Object)newAssetManager, externalResourceFile) == 0) {
                throw new IllegalStateException("Could not create new AssetManager");
            }
            Method mEnsureStringBlocks = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
            mEnsureStringBlocks.setAccessible(true);
            mEnsureStringBlocks.invoke((Object)newAssetManager, new Object[0]);
            if (activities != null) {
                for (Activity activity : activities) {
                    Resources resources = activity.getResources();
                    try {
                        Field mAssets = Resources.class.getDeclaredField("mAssets");
                        mAssets.setAccessible(true);
                        mAssets.set(resources, newAssetManager);
                    }
                    catch (Throwable ignore) {
                        Field mResourcesImpl = Resources.class.getDeclaredField("mResourcesImpl");
                        mResourcesImpl.setAccessible(true);
                        Object resourceImpl = mResourcesImpl.get(resources);
                        Field implAssets = resourceImpl.getClass().getDeclaredField("mAssets");
                        implAssets.setAccessible(true);
                        implAssets.set(resourceImpl, newAssetManager);
                    }
                    Resources.Theme theme = activity.getTheme();
                    try {
                        try {
                            Field ma = Resources.Theme.class.getDeclaredField("mAssets");
                            ma.setAccessible(true);
                            ma.set(theme, newAssetManager);
                        }
                        catch (NoSuchFieldException ignore) {
                            Field themeField = Resources.Theme.class.getDeclaredField("mThemeImpl");
                            themeField.setAccessible(true);
                            Object impl = themeField.get(theme);
                            Field ma = impl.getClass().getDeclaredField("mAssets");
                            ma.setAccessible(true);
                            ma.set(impl, newAssetManager);
                        }
                        Field mt = ContextThemeWrapper.class.getDeclaredField("mTheme");
                        mt.setAccessible(true);
                        mt.set(activity, null);
                        Method mtm = ContextThemeWrapper.class.getDeclaredMethod("initializeTheme", new Class[0]);
                        mtm.setAccessible(true);
                        mtm.invoke((Object)activity, new Object[0]);
                        if (Build.VERSION.SDK_INT < 24) {
                            Method mCreateTheme = AssetManager.class.getDeclaredMethod("createTheme", new Class[0]);
                            mCreateTheme.setAccessible(true);
                            Object internalTheme = mCreateTheme.invoke((Object)newAssetManager, new Object[0]);
                            Field mTheme = Resources.Theme.class.getDeclaredField("mTheme");
                            mTheme.setAccessible(true);
                            mTheme.set(theme, internalTheme);
                        }
                    }
                    catch (Throwable e) {
                        Log.e((String)"InstantRun", (String)("Failed to update existing theme for activity " + activity), (Throwable)e);
                    }
                    MonkeyPatcher.pruneResourceCaches(resources);
                }
            }
            if (Build.VERSION.SDK_INT >= 19) {
                Class<?> resourcesManagerClass = Class.forName("android.app.ResourcesManager");
                Method mGetInstance = resourcesManagerClass.getDeclaredMethod("getInstance", new Class[0]);
                mGetInstance.setAccessible(true);
                Object resourcesManager = mGetInstance.invoke(null, new Object[0]);
                try {
                    Field fMActiveResources = resourcesManagerClass.getDeclaredField("mActiveResources");
                    fMActiveResources.setAccessible(true);
                    ArrayMap arrayMap = (ArrayMap)fMActiveResources.get(resourcesManager);
                    references = arrayMap.values();
                }
                catch (NoSuchFieldException ignore) {
                    Field mResourceReferences = resourcesManagerClass.getDeclaredField("mResourceReferences");
                    mResourceReferences.setAccessible(true);
                    references = (Collection)mResourceReferences.get(resourcesManager);
                }
            } else {
                Class<?> activityThread = Class.forName("android.app.ActivityThread");
                Field fMActiveResources = activityThread.getDeclaredField("mActiveResources");
                fMActiveResources.setAccessible(true);
                Object thread = MonkeyPatcher.getActivityThread(context, activityThread);
                HashMap map = (HashMap)fMActiveResources.get(thread);
                references = map.values();
            }
            for (WeakReference wr : references) {
                Resources resources = (Resources)wr.get();
                if (resources == null) continue;
                try {
                    Field mAssets = Resources.class.getDeclaredField("mAssets");
                    mAssets.setAccessible(true);
                    mAssets.set(resources, newAssetManager);
                }
                catch (Throwable ignore) {
                    Field mResourcesImpl = Resources.class.getDeclaredField("mResourcesImpl");
                    mResourcesImpl.setAccessible(true);
                    Object resourceImpl = mResourcesImpl.get(resources);
                    Field implAssets = resourceImpl.getClass().getDeclaredField("mAssets");
                    implAssets.setAccessible(true);
                    implAssets.set(resourceImpl, newAssetManager);
                }
                resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pruneResourceCaches(Object resources) {
        Field field;
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object typedArray;
                Field typedArrayPoolField = Resources.class.getDeclaredField("mTypedArrayPool");
                typedArrayPoolField.setAccessible(true);
                Object pool = typedArrayPoolField.get(resources);
                Class<?> poolClass = pool.getClass();
                Method acquireMethod = poolClass.getDeclaredMethod("acquire", new Class[0]);
                acquireMethod.setAccessible(true);
                while ((typedArray = acquireMethod.invoke(pool, new Object[0])) != null) {
                }
            }
            catch (Throwable typedArrayPoolField) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Field mResourcesImpl = Resources.class.getDeclaredField("mResourcesImpl");
                mResourcesImpl.setAccessible(true);
                resources = mResourcesImpl.get(resources);
            }
            catch (Throwable mResourcesImpl) {
                // empty catch block
            }
        }
        Object lock = null;
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                field = resources.getClass().getDeclaredField("mAccessLock");
                field.setAccessible(true);
                lock = field.get(resources);
            }
            catch (Throwable field2) {}
        } else {
            try {
                field = Resources.class.getDeclaredField("mTmpValue");
                field.setAccessible(true);
                lock = field.get(resources);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lock == null) {
            lock = MonkeyPatcher.class;
        }
        Class<MonkeyPatcher> clazz = lock;
        synchronized (clazz) {
            MonkeyPatcher.pruneResourceCache(resources, "mDrawableCache");
            MonkeyPatcher.pruneResourceCache(resources, "mColorDrawableCache");
            MonkeyPatcher.pruneResourceCache(resources, "mColorStateListCache");
            if (Build.VERSION.SDK_INT >= 23) {
                MonkeyPatcher.pruneResourceCache(resources, "mAnimatorCache");
                MonkeyPatcher.pruneResourceCache(resources, "mStateListAnimatorCache");
            } else if (Build.VERSION.SDK_INT == 19) {
                MonkeyPatcher.pruneResourceCache(resources, "sPreloadedDrawables");
                MonkeyPatcher.pruneResourceCache(resources, "sPreloadedColorDrawables");
                MonkeyPatcher.pruneResourceCache(resources, "sPreloadedColorStateLists");
            }
        }
    }

    private static boolean pruneResourceCache(Object resources, String fieldName) {
        try {
            Class<Object> type;
            Field cacheField;
            Class<?> resourcesClass = resources.getClass();
            try {
                cacheField = resourcesClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ignore) {
                cacheField = Resources.class.getDeclaredField(fieldName);
            }
            cacheField.setAccessible(true);
            Object cache = cacheField.get(resources);
            if (Build.VERSION.SDK_INT < 16) {
                if (cache instanceof SparseArray) {
                    ((SparseArray)cache).clear();
                    return true;
                }
                if (Build.VERSION.SDK_INT >= 14 && cache instanceof LongSparseArray) {
                    ((LongSparseArray)cache).clear();
                    return true;
                }
            } else if (Build.VERSION.SDK_INT < 23) {
                if ("mColorStateListCache".equals(fieldName)) {
                    if (cache instanceof LongSparseArray) {
                        ((LongSparseArray)cache).clear();
                    }
                } else {
                    if (type.isAssignableFrom(ArrayMap.class)) {
                        Method clearArrayMap = Resources.class.getDeclaredMethod("clearDrawableCachesLocked", ArrayMap.class, Integer.TYPE);
                        clearArrayMap.setAccessible(true);
                        clearArrayMap.invoke(resources, cache, -1);
                        return true;
                    }
                    if (type.isAssignableFrom(LongSparseArray.class)) {
                        try {
                            Method clearSparseMap = Resources.class.getDeclaredMethod("clearDrawableCachesLocked", LongSparseArray.class, Integer.TYPE);
                            clearSparseMap.setAccessible(true);
                            clearSparseMap.invoke(resources, cache, -1);
                            return true;
                        }
                        catch (NoSuchMethodException e) {
                            if (cache instanceof LongSparseArray) {
                                ((LongSparseArray)cache).clear();
                                return true;
                            }
                        }
                    } else if (type.isArray() && type.getComponentType().isAssignableFrom(LongSparseArray.class)) {
                        LongSparseArray[] arrays;
                        for (LongSparseArray array : arrays = (LongSparseArray[])cache) {
                            if (array == null) continue;
                            array.clear();
                        }
                        return true;
                    }
                }
            } else {
                for (type = cacheField.getType(); type != null; type = type.getSuperclass()) {
                    try {
                        Method configChangeMethod = type.getDeclaredMethod("onConfigurationChange", Integer.TYPE);
                        configChangeMethod.setAccessible(true);
                        configChangeMethod.invoke(cache, -1);
                        return true;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

