package volanto.kalle.gpio;

import android.content.Intent;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    private TextView speedView;
    private TextView distanceView;
    private TextView rotationView;


    private static final int PIN_CONSTANT = 902;
    private static final int SPEED_PIN = 36;

    private Handler GPIOHandler;
    private GPIORunnable mGPIORunnable;

    private Handler textHandler;

    private Button tirediameterBtn;
    private EditText tirediameterEditText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        distanceView = findViewById(R.id.distanceView);
        speedView = findViewById(R.id.speedView);
        rotationView = findViewById(R.id.rotationView);


        double tire_diameter = 1;
        int revolutions = 0;

        GPIOHandler = new Handler();
        mGPIORunnable = new GPIORunnable(GPIOHandler, PIN_CONSTANT + SPEED_PIN, tire_diameter, revolutions);
        GPIOHandler.post(mGPIORunnable);

        textHandler = new Handler();

        tirediameterEditText = findViewById(R.id.tirediameterEditText);
        tirediameterBtn = findViewById(R.id.tirediameterBtn);
        tirediameterBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String i = tirediameterEditText.getText().toString();
                if (! i.equals("")) {
                    double new_diameter = Double.parseDouble(i);
                    mGPIORunnable.set_tire_diameter(new_diameter);
                    Toast.makeText(getApplicationContext(), "Diameter changed", Toast.LENGTH_LONG).show();
                }
                else{
                    Toast.makeText(getApplicationContext(), "Invalid diameter", Toast.LENGTH_LONG).show();
                }
            }
        });

        textHandler.post(new Runnable() {

            Intent data = new Intent();

            //int effeciency_helper = 0;

            @Override
            public void run() {
                distanceView.setText(String.format("Distance: %.2f km", mGPIORunnable.tell_distance()));

                speedView.setText(String.format("Speed: %.2f km/h",mGPIORunnable.tell_speed()));

                rotationView.setText(String.format("Revolutions: %d",mGPIORunnable.tell_revolutions()));


                textHandler.postDelayed(this, 1000);
            }
        });
    }


    @Override
    protected void onDestroy(){
        super.onDestroy();
        GPIOHandler.removeCallbacksAndMessages(null);
        textHandler.removeCallbacksAndMessages(null);
    }
}
