package volanto.kalle.gpio;

import android.os.Handler;

public class GPIORunnable implements Runnable{

    private GPIO mGPIO;
    private int revolutions;

    private int pin_value;

    private boolean ready_for_revolution;

    private Handler GPIOHandler;

    private double speed;

    // km/h

    private double seconds_from_last;

    //in meters
    private double tire_diameter;

    public GPIORunnable(Handler GPIOHandler, int pin, double tire_diameter, int revolutions){

        this.GPIOHandler = GPIOHandler;

        this.revolutions = revolutions;

        this.tire_diameter = tire_diameter;

        this.ready_for_revolution = true;

        this.mGPIO = new GPIO(938);

        this.mGPIO.initPin("in");

        this.speed = 0;

        this.seconds_from_last = 1;

        this.pin_value = 0;
    }

    @Override
    public void run() {

        pin_value = mGPIO.getState();

        //Log.i("GPIO", "xdd " + pin_value);

        if (ready_for_revolution){
            if (pin_value == 0){
                revolutions++;

                this.speed = (Math.PI * tire_diameter) * (1 / seconds_from_last);
                seconds_from_last = 0;

                ready_for_revolution = false;
            }
        }
        else {
            if (pin_value == 1){
                ready_for_revolution = true;
            }
        }

        /*
        if(seconds_from_last >= 0.25) {
            revolutions++;
            this.speed = (Math.PI * tire_diameter) * (1 / seconds_from_last);
            seconds_from_last = 0;
        }
        */

        seconds_from_last += 0.1; //==DELAY in seconds

        GPIOHandler.postDelayed(this, 100);
    }

    public int tell_revolutions(){
        return revolutions;
    }

    public void set_revolutions(int revolutions){
        this.revolutions = revolutions;
    }

    public double tell_distance(){
        // km
        return Math.PI*tire_diameter*revolutions/1000;
    }

    public double tell_speed(){
        // km/h
        return speed;
    }

    public double tell_tire_diameter(){
        return tire_diameter;
    }

    public void set_tire_diameter(double tire_diameter_new){
        this.tire_diameter = tire_diameter_new;
    }
}
