/*
 * 20.8.2018 poistettu !serial -rivi, nyt laite toimii ilman serialporttia. Lisätty ledikomentoja.
 * 21.8.2018 tekstiviestirekisteröityminen viimeistelty
 * 02.9.2018 siistitty ymmärrettävämpään muotoon
*/

#include "Adafruit_FONA.h"
#include <Adafruit_NeoPixel.h>

#define FONA_RST 6 //FONA:n RST-pinniin liitetty pin
#define PIN "0000" //SIM-kortin PIN
HardwareSerial *fonaSerial = &Serial1;
Adafruit_FONA fona = Adafruit_FONA(FONA_RST);
 
char replybuffer[140]; //väliaikaisia buffereita tekstiviestien lukemiseen
char buffer2[20];
char buffer3[20];
int8_t smsnum_new = 0; //tekstiviestien lukumäärä kortilla
float latitude, longitude, speed_kph, heading, speed_mph, altitude; //GPS-tiedot
bool netti = false; //gprs-yhteyden tila
bool ilmoitus = false; //sijaintitekstarin tila
bool viestit = false; //tekstiviestien luvun tila
int maara = 0; //puhnro määrä bufferissa
String numerot[10];

Adafruit_NeoPixel strip = Adafruit_NeoPixel(1, 8, NEO_GRB + NEO_KHZ800); //Floran RGB-LED
 
void setup()
{
  strip.begin();
  strip.setBrightness(50);
  strip.show(); // Initialize all pixels to 'off'
  color(strip.Color(255, 0, 0)); // Red
  Serial.begin(115200);
  delay(1000);
  Serial.println(F("FONA-pohja"));
  fonaSerial->begin(4800);
  if (! fona.begin(*fonaSerial)) {
    Serial.println(F("Couldn't find FONA"));
    while (1);
  }
  color(strip.Color(255, 100, 0)); //yellow
  fona.setGPRSNetworkSettings(F("internet"), F(""), F("")); //GPRS päälle, parametrit Telia-yhteensopivia
  if (!fona.enableGPS(true)) Serial.println(F("Failed to turn GPS on"));
  flushSerial();
  Serial.print(F("Unlocking SIM card: "));
  if (!fona.unlockSIM(PIN)) Serial.println(F("SIM Failed"));
  else Serial.println("SIM OK");
  while (!viestit) //viestien luku feilaa yleensä ekalla yrityksellä
  {
    color(strip.Color(255, 0, 0)); // Red
    smsnum_new = fona.getNumSMS(); //tsekataan ja luetaan sms
    if (smsnum_new < 0) Serial.println(F("Could not read SMS"));
    else if (smsnum_new > 0)
    {
      viestit = true;
      Serial.print(smsnum_new);
      Serial.println(F(" viestia, luetaan"));
      for(int i = 1; i<=smsnum_new; i++)
      {
        color(strip.Color(255, 0, 0)); // Red
        if (!fona.getSMSSender(i, replybuffer, 250)) Serial.println("SMS sender Failed!");
        Serial.print(F("FROM: ")); Serial.println(replybuffer);
        strcpy(buffer2, replybuffer);
        uint16_t smslen;
        if (! fona.readSMS(i, replybuffer, 250, &smslen)) Serial.println("Failed!");
        Serial.print(F("***** SMS #")); Serial.print(i);
        Serial.print(" ("); Serial.print(smslen); Serial.println(F(") bytes *****"));
        Serial.println(replybuffer);
        Serial.println(F("*****"));
        if (!strcmp(replybuffer, "B") || !strcmp(replybuffer, "b")) //poistetaan viestit numerolta jos viesti "B"
        {
          fona.deleteSMS(i);
          for (int n = 1; n <= i; n++)
          {
            if (numerot[n].length() > 2)
            {
              numerot[n].toCharArray(buffer3, 20);
              if(!strcmp(buffer2, buffer3))
              {
                numerot[n] = ""; //poistetaan numero bufferista jos lisätty aikaisemmin
                fona.deleteSMS(n); 
                Serial.print("nollattu #");
                Serial.println(n);
              }
            }
          }
        }
        else if (!strcmp(replybuffer, "A") || !strcmp(replybuffer, "a")) //lisätään numero listaan jos viesti "A"
        {
          if(strcmp(replybuffer, buffer2))
          {
            numerot[i] = buffer2;
            Serial.println(buffer2);
            maara = i;
          }
        }
        else{ //poistetaan "ylimääräiset" viestit mm. palveluntarjoajalta
          fona.deleteSMS(i);
          Serial.print("poistettu #");
          Serial.println(i);
        }
      }
      Serial.println("Numerot:"); //tulostetaan puhelinnumerot debugaukseen
      for (int n = 1; n <= maara; n++) Serial.println(numerot[n]);
    }
    else
    {
      Serial.println("Ei viestejä");
    }
    color(strip.Color(255, 100, 0)); //yellow
  }
  fona.setVolume(100); //volat täysille
  fona.setAudio(FONA_HEADSETAUDIO); //3,5mm audio
  fona.setMicVolume(FONA_HEADSETAUDIO, 15);
  if (!fona.enableGPRS(true)) Serial.println(F("Failed to turn GPRS on"));
  else netti = true;

  uint16_t vbat; //akun tila
  if (!fona.getBattPercent(&vbat)) Serial.println(F("Failed to read Batt"));
  else {
    Serial.print(F("VPct = ")); Serial.print(vbat); Serial.println(F("%"));
    if(vbat < 15) //akkua alle 15% jäljellä?
    {
      for(int i=1; i<=maara; i++)
      {
        if(numerot[i].length() > 2)
        {
          char viesti[141];
          char numero[20] = "";
          numerot[i].toCharArray(numero, 20);
          sprintf(viesti, "Akkua %i%% \nt. FONA", vbat);
          fona.sendSMS(numero, viesti);
          Serial.println(numero); Serial.println(viesti);
          break;
        }
      }
    }
  }
  
  for(int i=1; i<=maara; i++) //soitetaan kuhunkin numeroon
  {
    if(numerot[i].length() > 2)
    {
      unsigned long aloitus = millis();
      char numero[20];
      numerot[i].toCharArray(numero, 20);
      fona.callPhone(numero);
      while(fona.getCallStatus() == 4) delay(500); //odotetaan kunnes "punainen luuri"
    }
  }
}
 
void loop() {
  color(strip.Color(0, 0, 255)); // Blue
  int8_t callstat = fona.getCallStatus(); //vastataan automaattisesti mahdollisesti tulevaan puheluun
  if (callstat == 3)
  {
    color(strip.Color(255, 0, 0)); // Red
    if (! fona.pickUp()) {
      Serial.println(F("Pickup failed"));
    } else {
      Serial.println(F("Pickup OK!"));
    }
  }
  
  if(!ilmoitus) //sijaintiviesti menemään jos ei ole jo mennyt
  {
    int8_t stat = fona.GPSstatus(); //GPS:n status ja sijainti
    if (stat == 3) //vaaditaan 3D-fix
    {
      fona.getGPS(&latitude, &longitude, &speed_kph, &heading, &altitude);
      Serial.print("Sijainti: "); Serial.print(latitude); Serial.print (", "); Serial.println(longitude);
      char viesti[141];
      String bufferi = "Sijainti: http://maps.google.com/maps?q="; //bufferi viestille. sprintf ei tykkää floateista
      bufferi += String(latitude, 5);
      bufferi += ",";
      bufferi += String(longitude, 5);
      bufferi += "\nt. FONA";
      bufferi.toCharArray(viesti, 141);
      for(int i=1; i<=maara; i++)
      {
        if(numerot[i].length() > 2)
        {
          char numero[20];
          numerot[i].toCharArray(numero, 20);
          if (!fona.sendSMS(numero, viesti)) Serial.println("Viesti feilas");
          else 
          {
            Serial.println("Viesti onnistu");
            ilmoitus = true;
          }
        }
      }
    }
  }
 
  //getReply(F("AT+ECHO=1,32768,32768,32768,32768,1")); //yritys poistaa kaiku puhelusta, ei juuri dokumentoitu eikä toimi

  color(strip.Color(0, 255, 0)); // Green
  delay(5000);
}
 
void flushSerial() {
  while (Serial.available())
    Serial.read();
}

void color(uint32_t c) {
  for(uint16_t i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, c);
      strip.show();
  }
}
