package volanto.kalle.main_ui_1.graphs;

import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LegendRenderer;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.LineGraphSeries;

import volanto.kalle.main_ui_1.R;

public class GraphActivity extends AppCompatActivity implements SensorEventListener{

    private static final String TAG = "GraphActivity";

    LineGraphSeries<DataPoint> xDataPoints;
    LineGraphSeries<DataPoint> yDataPoints;
    LineGraphSeries<DataPoint> zDataPoints;
    GraphView sensorPlot;

    private double graphLastXValue;

    private double x_value_accelerometer;
    private double y_value_accelerometer;
    private double z_value_accelerometer;

    private Sensor accelerometer;
    private SensorManager SM;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_graph);

        graphLastXValue = 0;

        x_value_accelerometer = 0;
        y_value_accelerometer = 0;
        z_value_accelerometer = 0;

        //SENSORS
        //sensormanager
        SM = (SensorManager)getSystemService(SENSOR_SERVICE);

        //accelerometer
        accelerometer = SM.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        if (accelerometer == null){
            Log.e(TAG, "Accelerometer not found");
            Toast.makeText(getApplicationContext(), "Accelerometer not found", Toast.LENGTH_LONG).show();
            finish();
        }

        //registering sensor listener
        SM.registerListener((SensorEventListener) this, accelerometer, SensorManager.SENSOR_DELAY_GAME);


        //PLOTTING
        sensorPlot = (GraphView)findViewById(R.id.sensorPlot);

        sensorPlot.setTitle("accelerometer");

        xDataPoints = new LineGraphSeries<>();
        xDataPoints.setTitle("X");
        xDataPoints.setColor(Color.BLACK);
        yDataPoints = new LineGraphSeries<>();
        yDataPoints.setTitle("Y");
        yDataPoints.setColor(Color.BLUE);
        zDataPoints = new LineGraphSeries<>();
        zDataPoints.setTitle("Z");
        zDataPoints.setColor(Color.RED);

        sensorPlot.addSeries(xDataPoints);
        sensorPlot.addSeries(yDataPoints);
        sensorPlot.addSeries(zDataPoints);

        sensorPlot.getViewport().setYAxisBoundsManual(true);
        sensorPlot.getViewport().setXAxisBoundsManual(true);

        setCameraY(15, -15);
        setCameraX(20);

        sensorPlot.getGridLabelRenderer().setHorizontalLabelsVisible(false);

        sensorPlot.getLegendRenderer().setVisible(true);
        sensorPlot.getLegendRenderer().setBackgroundColor(Color.GRAY);
        sensorPlot.getLegendRenderer().setAlign(LegendRenderer.LegendAlign.TOP);
    }

    private void setCameraY(double top, double bottom){

        sensorPlot.getViewport().setMaxY(top);
        sensorPlot.getViewport().setMinY(bottom);
    }

    private void setCameraX(double offset){

        sensorPlot.getViewport().setMinX(graphLastXValue - offset);
        sensorPlot.getViewport().setMaxX(graphLastXValue);
    }

    private void initGraph(double plot_value, LineGraphSeries sensorDataPoints) {

        try {
            sensorDataPoints.appendData(new DataPoint(graphLastXValue, plot_value), false, 100);
        } catch (IllegalArgumentException e) {
            Log.e(TAG, "createScatterPlot: IllegalArgumentException: " + e.getMessage());
        }
    }

    //SENSORS
    @Override
    public void onSensorChanged(SensorEvent sensorEvent){

        if (sensorEvent.sensor == accelerometer){

            x_value_accelerometer = (double) sensorEvent.values[0];
            initGraph(x_value_accelerometer, xDataPoints);


            y_value_accelerometer = (double) sensorEvent.values[1];
            initGraph(y_value_accelerometer, yDataPoints);


            z_value_accelerometer = (double) sensorEvent.values[2];
            initGraph(z_value_accelerometer, zDataPoints);

            graphLastXValue += 0.25;

            sensorPlot.getViewport().setXAxisBoundsManual(true);
            sensorPlot.getViewport().setMinX(graphLastXValue - 20);
            sensorPlot.getViewport().setMaxX(graphLastXValue);

            setCameraX(20);
        }
    }



    @Override
    public void onAccuracyChanged(Sensor sensor, int i){
        //not used
    }
    //SENSORS



}
