package volanto.kalle.main_ui_1.gpio_speed;

import android.os.Handler;
import android.util.Log;

import volanto.kalle.main_ui_1.gpio_speed.GPIO;

public class GPIORunnable implements Runnable{

    private GPIO mGPIO;
    private int revolutions;

    private int pin_value;

    private boolean ready_for_revolution;

    private Handler GPIOHandler;

    private double speed;

    // km/h

    private long millis_from_last;
    private long last_revolution_time;

    //in meters
    private double tire_diameter;

    public GPIORunnable(Handler GPIOHandler, int pin, double tire_diameter, int revolutions){

        this.GPIOHandler = GPIOHandler;

        this.revolutions = revolutions;

        this.tire_diameter = tire_diameter;

        this.ready_for_revolution = true;

        this.mGPIO = new GPIO(pin);

        mGPIO.initPin("in");

        mGPIO.activationPin();

        mGPIO.setInOut("in");

        this.speed = 0;

        this.millis_from_last = 0;

        this.last_revolution_time = System.currentTimeMillis();

        this.pin_value = 0;
    }

    @Override
    public void run() {

        pin_value = mGPIO.getState();

        Log.i("GPIO", "xdd " + pin_value);

        if (ready_for_revolution){
            if (pin_value == 0){
                revolutions++;

                millis_from_last = System.currentTimeMillis() - last_revolution_time;
                last_revolution_time = System.currentTimeMillis();

                this.speed = (Math.PI * tire_diameter) * (1000 / (millis_from_last));

                ready_for_revolution = false;
            }
        }
        else {
            if (pin_value == 1){
                ready_for_revolution = true;
            }
        }

        GPIOHandler.postDelayed(this, 50);
    }

    public int tell_revolutions(){
        return revolutions;
    }

    public void set_revolutions(int revolutions){
        this.revolutions = revolutions;
    }

    public double tell_distance(){
        // km
        return Math.PI*tire_diameter*revolutions/1000;
    }

    public double tell_speed(){
        // km/h
        return speed;
    }

    public double tell_tire_diameter(){
        return tire_diameter;
    }

    public void set_tire_diameter(double tire_diameter_new){
        this.tire_diameter = tire_diameter_new;
    }
}
