package volanto.kalle.main_ui_1;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import volanto.kalle.main_ui_1.gpio_speed.GPIOActivity;
import volanto.kalle.main_ui_1.gpio_speed.GPIORunnable;
import volanto.kalle.main_ui_1.gps.GpsActivity;
import volanto.kalle.main_ui_1.graphs.GraphActivity;
import volanto.kalle.main_ui_1.heartbeat.HeartbeatActivity;


public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";

    //COMMENTED LINES IN MAINACTIVITY AND GPIOACTIVITY MAKE
    //THE DISTANCE CALCULATIONS HAPPEN EVEN WHEN USING OTHER ACTIVITIES

    //GPIO
    //dragonboard has a gpio pin offset of 902
    /*private static final int PIN_CONSTANT = 902;
    private static final int SPEED_PIN = 69;

    private double tire_diameter;

    int revolutions;

    private Handler GPIOHandler;

    private GPIORunnable mGPIORunnable;

    */

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        /*
        tire_diameter = 0.7;
        revolutions = 0;
        //GPIO
        start_GPIO(tire_diameter, revolutions);
        */
        Button GPIOBtn = (Button) findViewById(R.id.GPIOBtn);
        GPIOBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent openGPIO;
                openGPIO = new Intent(getApplicationContext(), GPIOActivity.class);
                /*
                openGPIO.putExtra("tire_diameter", mGPIORunnable.tell_tire_diameter());
                openGPIO.putExtra("revolutions", mGPIORunnable.tell_revolutions());
                startActivityForResult(openGPIO, 1);
                GPIOHandler.removeCallbacks(mGPIORunnable);
                */
                startActivity(openGPIO);
            }
        });

        //gps
        Button gpsBtn = (Button) findViewById(R.id.gpsBtn);
        gpsBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent openMaps;
                openMaps = new Intent(getApplicationContext(), GpsActivity.class);
                startActivity(openMaps);
            }
        });


        //heartbeat
        Button heartbeatBtn = (Button) findViewById(R.id.heartbeatBtn);
        heartbeatBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent openHeartbeat;
                openHeartbeat = new Intent(getApplicationContext(), HeartbeatActivity.class);
                startActivity(openHeartbeat);
            }
        });


        //graphs
        Button graphBtn = (Button) findViewById(R.id.graphBtn);
        graphBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent openGraph;
                openGraph = new Intent(getApplicationContext(), GraphActivity.class);
                startActivity(openGraph);
            }
        });
    }

    /*
    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if(requestCode == 1 && resultCode == RESULT_OK){

            Bundle extras = data.getExtras();
            if(extras != null) {
                tire_diameter = (double) extras.get("tire_diameter");
                revolutions = (int) extras.get("revolutions");
            }
            start_GPIO(tire_diameter, revolutions);
        }
    }
    */

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /*
    public void start_GPIO(double tire_diameter, int revolutions_now){
        //GPIO
        GPIOHandler = new Handler();
        mGPIORunnable = new GPIORunnable(GPIOHandler, SPEED_PIN + PIN_CONSTANT, tire_diameter, revolutions_now);
        GPIOHandler.post(mGPIORunnable);
    }
    */
}