#File name: coldsideCompensationTests.py
#Author: Antti Matikainen
#Date created: 27.6.2018
#Date last modified: 27.6.2018
#Python version: yes

#This file contains some preliminary tests to ensure
#that the coldside compensation code functions as intended.
#Tests are primarily performed using chosen mV and temperature values
#instead of sensor data.

import sys
import os
import math

addpath=os.path.join(os.getcwd(),'Thermocouple')
sys.path.append(addpath)
import coldsideCompensation
from tc import Thermocouple

#Arbitrarily chosen temperature values for testing.
#In celsius
tempIceBath = 0
temp1 = 100
temp2 = 200
temp3 = 300
temp4 = 400
temp5 = 500
temp6 = 600
temp7 = 5000

#Converting some temperatures to mv values.
tempIceBathmv = Thermocouple.typek_to_mv(tempIceBath)
temp1mv = Thermocouple.typek_to_mv(temp1)
temp2mv = Thermocouple.typek_to_mv(temp2)
temp3mv = Thermocouple.typek_to_mv(temp3)
temp4mv = Thermocouple.typek_to_mv(temp4)
temp5mv = Thermocouple.typek_to_mv(temp5)
temp6mv = Thermocouple.typek_to_mv(temp6)

print ("300c temp mv: " + str(temp3mv))
try:
  temp7mv = Thermocouple.typek_to_mv(temp7)
except ValueError:
  print ("Caught the ValueError")

#Testing coldside compensation function with legitimate inputs.
print (tempIceBath)
print (coldsideCompensation.coldsideCompensation(tempIceBathmv, tempIceBath, 'K'))
print (temp1)
print (coldsideCompensation.coldsideCompensation(temp1mv, tempIceBath, 'K'))
print (temp2)
print (coldsideCompensation.coldsideCompensation(temp2mv, tempIceBath, 'K'))
print (temp3)
print (coldsideCompensation.coldsideCompensation(temp3mv, tempIceBath, 'K'))
print (temp4)
print (coldsideCompensation.coldsideCompensation(temp4mv, tempIceBath, 'K'))
print (temp5)
print (coldsideCompensation.coldsideCompensation(temp5mv, tempIceBath, 'K'))
print (temp6)
print (coldsideCompensation.coldsideCompensation(temp6mv, tempIceBath, 'K'))

#Testing coldside compensation function with invalid inputs.
try:
  print (coldsideCompensation.coldsideCompensation(temp1mv, tempIceBath, 'Y'))
except:
  print("Caught an error")
try:
  print (coldsideCompensation.coldsideCompensation(temp1mv, tempIceBath, 10))
except:
  print("Caught an error")
try:
  print (coldsideCompensation.coldsideCompensation(temp1mv, tempIceBath, "String"))
except:
  print("Caught an error")

