#File name: coldsideCompensation.py
#Author: Antti Matikainen
#Date created: 27.6.2018
#Date last modified: 27.6.2018
#Python Version: yes

#This file contains the function for converting readings
#from the thermocouple into a temperature which is returned.

#Inputs:
#- Temperature reading from digital temperature sensor for coldside compensation.
#- Reading from the thermocouple passed through the ADC.
#- Thermocouple type for future expansions.

#Output:
#- Integer value representing the temperature of the reading in Celsius.

#Utilizes thermocouple conversion script written by andygock
#Included unmodified in folder Thermocouple

import sys
import os
addpaththerm = os.path.join(os.getcwd(),'Thermocouple')
sys.path.append(addpaththerm)
from tc import Thermocouple

def coldsideCompensation(thermocoupleReading, coldsideReading, thermocoupleType):
  #Steps: Convert coldside reading to voltage
  # Add to thermocouple reading
  # Convert sum to temperature

  #If statement to allow for support for assorted Thermocouples.
  #At the moment only allows for K types but with the
  #Thermocouple implementation expansion should be trivial.

  if(thermocoupleType == 'K'):
    #Convert coldside temperature reading into voltage.
    try:
      coldsidemV =  Thermocouple.typek_to_mv(coldsideReading)
    except ValueError:
      raise ValueError("Invalid input for coldside compensation reading.")
    #Sum converted coldside voltage and reading.
    try:
      summV = coldsidemV + thermocoupleReading
    except ValueError:
      raise ValueError("Invalid input for thermocouple reading.")
    #Convert summed mV into temperature.
    compensatedTemperature = Thermocouple.mv_to_typek(summV)

  #Else statement for invalid thermocoupleType readings.
  else:
    raise ValueError("Invalid or unimplemented thermocouple type")

  #Return temperature value
  return compensatedTemperature
