#file name: writeStringtoFile.py
#Author: Antti Matikainen
#Date created: 3.7.2018
#Date last modified: 3.7.2018
#Python version: yes

#This file contains a utility function for writing a string to a file.
#Can be used in other functions in order to avoid having to
#include code for opening the file, writing into it and closing the file.
#Means if something about writing to the file needs to be changed it can be
#done in one place instead of having to hunt down every instance.

#Inputs:
#-String with the target file name and path to it.
#-String to write into said file.

#Output:
#-Boolean output in order to indicate success or failure.

import sys

def writeStringToFile(targetFileString, inputString):
  try:
    #Open file pointed to by first input string.
    file = open(targetFileString, 'a')
    #Write second input string to file.
    file.write(inputString)
    #Close file after writing.
    file.close()
  except IOError:
    print("I/O error")
    return 0
  except:
    print("Failed due to unknown error")
    return 0

  #Return 1 to indicate successful operation.
  return 1
