#include <SPI.h>


const int slavePin = 10;
SPISettings settings(2000000, MSBFIRST, SPI_MODE3);
uint8_t value;

void setup() {
  pinMode (slavePin, OUTPUT);
  Serial.begin(9600);
  SPI.begin();
  AD7793_Reset();
  AD7793_SetGain();
  AD7793_SetUpdateRate();

}

void loop() {
   unsigned long value;
  if(AD7793_Ready())
  {
    value = AD7793_GetRegisterValue();
    Serial.println(value);
  }
  delay(2000);
}


void SPI_Write(unsigned char* data, int size)
{
  SPI.beginTransaction(settings);
  digitalWrite(slavePin, LOW);
  for (int x = 0; x < size; x++)
  {
    SPI.transfer(data[x]);
  }
  digitalWrite (slavePin, HIGH);
  SPI.endTransaction();
}

unsigned char SPI_Read()
{
  SPI.beginTransaction(settings);
  digitalWrite(slavePin, LOW);
  value = SPI.transfer(0);
  Serial.println(value);
  digitalWrite (slavePin, HIGH);
  SPI.endTransaction();
  return value;
}

void AD7793_Reset(void)
{
  unsigned char data[4] = {0xff, 0xff, 0xff, 0xff};
  SPI_Write(data, 4);
  delay(50); 
}

void AD7793_SetGain()
{
  unsigned char communications[8] = {0,0,0,1,0,0,0,0};
  SPI_Write(communications,8);
  unsigned char data[16] = {0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0};
  SPI_Write(data,16);
  delay(50);
}

void AD7793_SetUpdateRate()
{
  unsigned char communications[8] = {0,0,0,0,1,0,0,0};
  SPI_Write(communications,8);
  unsigned char data[16] = {0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1};
  SPI_Write(data,16);
  delay(50);
}

bool AD7793_Ready(){
  while(digitalRead(12) == LOW)
  {
    ;
  }
  return true;
}

unsigned long AD7793_GetRegisterValue()
{
  unsigned char communications[8] = {0,1,0,1,1,1,0,0};
  SPI_Write(communications,8);
  return  SPI_Read();
}



