/* Sisältää koodia GNU ja MIT lisensseillä. GNU-lisenssin alaisia ovat MAXREFDES117# -sensorin mukana 
 *  tulleet koodin osat sekä kirjastot max30102.h & -.cpp, algorithm.cpp & -.h. Sensorin alkuperäinen koodi 
 *  löytyy internetistä nimellä RD117_ARDUINO, tämä koodi sisältää osia sekä muokkauksia alkuperäisestä koodista. 
 *  Lisäksi kirjastot DallasTemperature.cpp & -.h, SlowSoftI2CMaster.h & -.cpp, sekä SD.cpp ja -.h, kuuluvat GNU lisenssin alaisuuteen. 
 *  
 *  MIT-lisenssin alaisia koodeja ovat itse kirjoitetut koodit, sekä alkuperäisten koodien muokkaukset.
 *  
 *  Lisäksi koodin kirjoituksessa käytetyn OneWire.h & -.cpp tiedostojen tekijänoikeudet kuuluvat Jim Studtille 
 *  sekä muille koodin muokkaajille. Nimet ja päivämäärät löytyvät OneWire -kirjaston alusta. 
 *  
 *  Funktioiden viittauksilla kirjastoihin on niiden alkuperäinen lisenssi selvitettävissä. Koodiin ei lisenssejä 
 *  ole erotettuna, sillä koodi on muodostettu sekoituksena valmissta ja itsekirjoitetusta. 
 *  
 *  Lisenssien tarkemmat tiedot löytyvät tiedostosta lisenssitiedot.txt. 
*/
// Aseta nopeudeksi 72 MHz Teensyllä
#include <Wire.h> // Must include Wire library for I2C
#include <SparkFun_MMA8452Q.h> // Includes the SFE_MMA8452Q library

#include <Audio.h>
#include <SPI.h>
#include <SD.h>
#include <SerialFlash.h>
#include <Arduino.h> 
#include <OneWire.h>
#include <DallasTemperature.h>
#include "algorithm.h" 
#include "max30102.h" 

AudioInputI2S            audioInput;
AudioAnalyzePeak         peak;
AudioConnection          patchCord3(audioInput, 0, peak, 0);
AudioPlaySdWav           playSdWav1;
AudioOutputI2S           i2s1;
AudioConnection          patchCord1(playSdWav1, 0, i2s1, 0);
AudioConnection          patchCord2(playSdWav1, 1, i2s1, 1);
AudioControlSGTL5000     sgtl5000_1;

#define SDCARD_CS_PIN    10
#define SDCARD_MOSI_PIN  7
#define SDCARD_SCK_PIN   14

MMA8452Q accel;

#define MAX_BRIGHTNESS 255
#define ONE_WIRE_BUS 4

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

const int32_t n_ir_buffer_length=BUFFER_SIZE; 
uint32_t aun_ir_buffer[n_ir_buffer_length]; //infrared LED sensor data
uint32_t aun_red_buffer[n_ir_buffer_length];  //red LED sensor data

float xalku = 0, yalku = 0, zalku = 0;
float xerotus, yerotus, zerotus;

bool merkki = 1;
char mikki_paalla = 50, kiihtyvyysanturi_paalla = 52, laulunumero = 0;
int maara = 0, piikkien_maara = 0;

unsigned long aika, aika1, HRaika, Aika, tempe;
const unsigned long aikavali = 10000;

int monoPeak = 0, state = 0, l = 0;

int32_t n_spo2, n_heart_rate, i;  //SPO2 and heart rate value
int8_t ch_spo2_valid, ch_hr_valid;  //indicator to show if the calculations for spo2 & heart rate are valid
uint8_t uch_dummy;
float Celcius=0, Fahrenheit=0, f_temp;
uint32_t un_min, un_max, un_prev_data, un_brightness;  //variables to calculate the on-board LED brightness that reflects the heartbeats 
int punPin = 21, sinPin = 20;

const int myInput = AUDIO_INPUT_MIC;

void setup()
{  
  Serial1.begin(9600);  
  delay(100);
  sensors.begin();
  accel.init();
  AudioMemory(8);
  sgtl5000_1.enable();
  sgtl5000_1.inputSelect(myInput);
  sgtl5000_1.volume(0.5);
  sgtl5000_1.micGain(36);
  SPI.setMOSI(SDCARD_MOSI_PIN);
  SPI.setSCK(SDCARD_SCK_PIN);
  if (!(SD.begin(SDCARD_CS_PIN))) 
  {
    while (1) 
    {
      Serial.println("Unable to access the SD card");
      delay(500);
    }
  }
  Aika = millis();
  aika1 = millis();
  HRaika = millis();
  tempe = millis();
  pinMode(5, INPUT);  //pin D5 connects to the interrupt output pin of the MAX30102
  delay(500); 
  maxim_max30102_read_reg(REG_INTR_STATUS_1,&uch_dummy);  //Reads/clears the interrupt status register
  uch_dummy=Serial.read();
  maxim_max30102_init();  //initialize the MAX30102
  pinMode(punPin, OUTPUT);
	pinMode(sinPin, OUTPUT);
 
  for(i=0;i<n_ir_buffer_length;i++)  //read the first 100 samples for heartrate calculation, and determine the signal range
  {
    while(digitalRead(5)==1);  //wait until the interrupt pin asserts
    maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
    if(un_min>aun_red_buffer[i])
      un_min=aun_red_buffer[i];  //update signal min
    if(un_max<aun_red_buffer[i])
      un_max=aun_red_buffer[i];  //update signal max
  }
  
  un_prev_data=aun_red_buffer[i];
  maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_spo2, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid);  

	for(byte k=0;k<5;k++) // Tarkistaa koodin kääntymisen 
	{
		analogWrite(sinPin, 150);
		analogWrite(punPin, 150);
		delay(100);
		analogWrite(sinPin, 0);
		analogWrite(punPin, 0);
		delay(100);
	}
	aloitusaani();
	} // setup loppuu

elapsedMillis fps;

void loop()
{	
	 i=0;
   un_min=0x3FFFF;
   un_max=0;

	if(Serial1.available() > 0)
	{
    state = Serial1.read();
    if(state == 51 || state == 52) kiihtyvyysanturi_paalla = state;
    if(state == 49 || state == 50) mikki_paalla = state;
    if(state == 53) laulunumero++;
    if(state == 54) aloitusaani();
  }

  if (accel.available() && kiihtyvyysanturi_paalla == 52) //Lukee kiihtyvyysanturin aloitusarvo
  {
		accel.read();
		if(millis()- Aika > 10 && (abs(accel.cx) > 1.3 || abs(accel.cy) > 1.3 || abs(accel.cz) > 1.3))
			{
				Aika = millis();
				maara++;
    	}
  }
	if (fps > 24)
	{
   	if (peak.available() && mikki_paalla == 50)
   	{
    	 fps = 0;
    	 monoPeak = peak.read() * 30.0;
   	}
    else monoPeak = 0;
  }
   
  if(millis() - aika1 > 20)
  {
    if(monoPeak > 29)
    {
   		piikkien_maara++;
 		}
 		aika1 = millis();
  	}
   
	if(millis() - aika > 6000)
	{
		maara = 0;
		piikkien_maara = 0;
		aika = millis();
		Serial1.println("Heiluta ranneketta"); // Jätetty demopäivää varten aktivoimaan laulun 
	}

	if((maara > 50) || (piikkien_maara > 6))
	{
		maara = 0;
		piikkien_maara = 0;
		monoPeak = 0;
   	delay(100);
   	toisto(laulunumero, aika, aikavali);
	}

  if(millis() - HRaika > 30000) 
  { 
  Serial1.println("Mittaa elintoimintoja.");
  HRaika = millis();
  elintoiminnot();
  }
  if (millis() - tempe > 60000)
  {
   lampotila();
   tempe = millis();
	}
  }

void aloitusaani()
{
	if (playSdWav1.isPlaying() == false) 
   	{
      playSdWav1.play("avaus.WAV");
     	delay(10); // wait for library to parse WAV info
   	}
    delay(4000);
}

void toisto(char laulunumero, unsigned long aika, const unsigned long aikavali)
{
	if (playSdWav1.isPlaying() == false) 
   	{
    	Serial1.println("Liiketta tai aanta havaittu.");
      Serial1.println("Aloitetaan aanentoistaminen...");
     	if(laulunumero > 1) laulunumero = 0;
      if(laulunumero == 0) playSdWav1.play("lullaby1.WAV");
      if(laulunumero == 1) playSdWav1.play("Bird1.WAV");
     	delay(10); // wait for library to parse WAV info
   	}
 		aika = millis();
  	while(1)
    {
    	if (playSdWav1.isPlaying() == false)
    	{
    		playSdWav1.play("lullaby1.WAV");
    		delay(10);
    	}
			if(millis() - aika > aikavali)
			{
				Serial1.println("Musiikin toisto loppuu");
				playSdWav1.stop();
				delay(500);
				break;
			}
			if(Serial1.available() > 0){
          state = Serial1.read();
          if(state == 53){
            Serial.println("Uusi laulu");
            laulunumero++;
            playSdWav1.stop();
            delay(500);
            if(laulunumero > 1) laulunumero = 0;
            if(laulunumero == 0) playSdWav1.play("lullaby1.WAV");
            if(laulunumero == 1) playSdWav1.play("Bird1.WAV");
          }
    }
    }
    	delay(50);
}

//elintoimintojen määrittäminen MAXREFDES117# -anturilla
void elintoiminnot()
{
	for(i=0;i<n_ir_buffer_length;i++)  //read the first 100 samples for heartrate calculation, and determine the signal range
  {
    while(digitalRead(5)==1);  //wait until the interrupt pin asserts
    maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
    
    if(un_min>aun_red_buffer[i])
      un_min=aun_red_buffer[i];  //update signal min
    if(un_max<aun_red_buffer[i])
      un_max=aun_red_buffer[i];  //update signal max
  }
  un_prev_data=aun_red_buffer[i];
  maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_spo2, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid);  
  
  	while(millis()- HRaika < 30000)
  	{
    //dumping the first 25 sets of samples in the memory and shift the last 75 sets of samples to the top
    for(i=25;i<n_ir_buffer_length;i++)
    {
      aun_red_buffer[i-25]=aun_red_buffer[i];
      aun_ir_buffer[i-25]=aun_ir_buffer[i];

      //update the signal min and max
      if(un_min>aun_red_buffer[i])
        un_min=aun_red_buffer[i];
      if(un_max<aun_red_buffer[i])
        un_max=aun_red_buffer[i];
    }
    for(i = n_ir_buffer_length- 25;i<n_ir_buffer_length;i++) //take 25 sets of samples before calculating the heart rate.
    {
      un_prev_data=aun_red_buffer[i-1];
      while(digitalRead(5)==1);
      digitalWrite(9, !digitalRead(9));
      maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));
      delay(40);
      if(aun_red_buffer[i]>un_prev_data) //calculate the brightness of the LED
      {
        f_temp=aun_red_buffer[i]-un_prev_data;
        f_temp/=(un_max-un_min);
        f_temp*=MAX_BRIGHTNESS;
        f_temp=un_brightness-f_temp;
        if(f_temp<0)
          un_brightness=0;
        else
          un_brightness=(int)f_temp;
      }
      else
      {
        f_temp=un_prev_data-aun_red_buffer[i];
        f_temp/=(un_max-un_min);
        f_temp*=MAX_BRIGHTNESS;
        un_brightness+=(int)f_temp;
        if(un_brightness>MAX_BRIGHTNESS)
          un_brightness=MAX_BRIGHTNESS;
      }
    }
    if(l > 5)
    {
    if(n_heart_rate < 200 && n_heart_rate > 20){
      Serial1.print(F("Syke: "));
      Serial1.println(n_heart_rate, DEC);
    }
    if(n_spo2 < 120 && n_spo2 > 20)
    {
      Serial1.print(F("Happisaturaatio: ")); 
      Serial1.println(n_spo2, DEC); 
      if(n_spo2 < 90)
      {
      	Serial1.println(F("Tarkista lapsesi vointi"));
      }
      else if(n_spo2 < 95)
      {
      	Serial1.println(F("Seuraa lapsen vointia."));
      }
    }
    }
      maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_spo2, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid);
  l++; 
  }
  l = 0; 
   HRaika = millis();  
}
//Lämpötilan määrittäminen DS18B20-anturin avulla 
void lampotila()
{
		sensors.requestTemperatures(); 
    Celcius=sensors.getTempCByIndex(0);
    Fahrenheit=sensors.toFahrenheit(Celcius);
    Serial1.println();
    if(Celcius > 126)
    {
    	Serial1.println("Akun varaus alhainen!");
    }
    Serial1.print("Lampotila: ");
    Serial1.print(Celcius);
		Serial1.println(" C");
												 // Lämpötilat alla asetettu havainnollistamaan lämpötilan vaikutusta valoihin
		if(Celcius <= 25)   // Todellisessa versiossa ei ledien yhtäaikaisella palamisella ole tarkoituksen mukaista hyötyä
		{
		analogWrite(sinPin, 255);
		analogWrite(punPin, 0);
		}
		else if(Celcius <= 27)
		{
		analogWrite(sinPin, 150);
		analogWrite(punPin, 0);
		}
		else if(Celcius <= 29)
		{
		analogWrite(punPin, 150);
		analogWrite(sinPin, 150);
		}
		else if(Celcius <= 31)
		{
		analogWrite(punPin, 150);
		analogWrite(sinPin, 0);
		}
		else
		{
		analogWrite(punPin, 255);
		analogWrite(sinPin, 0);
		}
}

